LIBMALI_MTK_GPUINFO_FILE=${MOCK_LIBMALI_MTK_GPUINFO_FILE:-/sys/class/misc/mali0/device/gpuinfo}

libmali_mtk_get_cpu() {
    if [ ! -f "$LIBMALI_MTK_GPUINFO_FILE" ]; then
        echo "Mali gpuinfo file not present" >&2
        return 1
    fi

    case "$(cat "$LIBMALI_MTK_GPUINFO_FILE")" in
        "Mali-G52 1 cores r1p0"*)
            echo mt8365
            ;;
        "Mali-G57 3 cores r0p0"*)
            echo mt8188
            ;;
        "Mali-G57 2 cores r0p0"*)
            echo mt8188
            ;;
        "Mali-G57 5 cores r0p1"*)
            echo mt8195
            ;;
        *)
            echo "Unknown Mali GPU" >&2
            return 1
            ;;
    esac
    return 0
}

# take one argument - package name
remove_libwayland_egl() {
      # Remove symlink created in postinst, if they point to libmali
      if readlink -f /usr/lib/aarch64-linux-gnu/libwayland-egl.so.1.20.0 | grep libmali; then
          echo "Removing all hacks with regards to libwayland-egl"
          for f in     libwayland-egl.so \
                       libwayland-egl.so.1 \
                       libwayland-egl.so.1.20.0; do
              unlink /usr/lib/aarch64-linux-gnu/$f
          done
          for f in libwayland-egl.so.1; do
              dpkg-divert --package $1 --remove --rename --divert \
                          /usr/lib/aarch64-linux-gnu/$f.REAL \
                          /usr/lib/aarch64-linux-gnu/$f
          done
          for f in libwayland-egl.so.1.20.0
              do dpkg-divert --remove --rename --divert \
                         /usr/lib/aarch64-linux-gnu/mali/backup/$f.REAL \
                         /usr/lib/aarch64-linux-gnu/$f
          done
      fi
}
